TITLE 									{ exa072.pde }
   'Metal Bar in a Tube'
SELECT
   errlim=1e-3     spectral_colors
VARIABLES
   U
DEFINITIONS
   r0=1.0     b=0.3     U_bar=1.0
   Ex=-dx(U)     Ey=-dy(U)
   E=-grad(U)     Em=magnitude(E)
EQUATIONS
   div( grad( U))=0
BOUNDARIES
region 'domain'	
   start 'tube' (r0,0)  value(U)=0  arc( center=0,0) angle=360  	
   start 'bar' (-b,-b) value( U)=U_bar			{ Cutout for bar }
   line to (b,-b) to (b,b) to (-b,b)  close
PLOTS
   contour( U)     surface( U) 	
   elevation( U) on 'tube'     elevation( U) on 'bar'	
   contour( Em)     elevation( Em) on 'tube'     elevation( Em) on 'bar'
   vector( E) norm
END

